package com.qboxus.tictic.activitesfragments.livestreaming.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;

import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.qboxus.tictic.R;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel;
import com.qboxus.tictic.databinding.ItemInvitePkBattleBinding;
import com.qboxus.tictic.interfaces.AdapterClickListener;

import java.util.ArrayList;

public class PkBattleAdapter extends RecyclerView.Adapter<PkBattleAdapter.CustomViewHolder> {
    public Context context;
    ArrayList<LiveUserModel> user_dataList = new ArrayList<>();

    AdapterClickListener adapterClickListener;

    public PkBattleAdapter(Context context, ArrayList<LiveUserModel> user_dataList, AdapterClickListener listener) {
        this.context = context;
        this.user_dataList = user_dataList;
        this.adapterClickListener = listener;
    }

    @Override
    public CustomViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewtype) {
        ItemInvitePkBattleBinding binding = DataBindingUtil.inflate(LayoutInflater
                .from(viewGroup.getContext()), R.layout.item_invite_pk_battle, viewGroup, false);
        return new CustomViewHolder(binding);

    }

    @Override
    public int getItemCount() {
        return user_dataList.size();
    }

    public void filter(ArrayList<LiveUserModel> filter_list) {
        this.user_dataList = filter_list;
        notifyDataSetChanged();
    }

    @Override
    public void onBindViewHolder(final CustomViewHolder holder, final int i) {
        final LiveUserModel item = user_dataList.get(i);
        holder.bind(i, adapterClickListener, item);
        holder.binding.userName.setText(item.getUserName());
        holder.binding.userPhone.setText(item.getDescription());

        if (item.getUserPicture() != null && !item.getUserPicture().equals("")) {
            ImageRequest request = ImageRequestBuilder.newBuilderWithSource(Uri.parse(item.getUserPicture())).build();
            DraweeController controller = Fresco.newDraweeControllerBuilder()
                    .setImageRequest(request)
                    .setOldController(holder.binding.userImage.getController())
                    .build();
            holder.binding.userImage.setController(controller);
        } else {
            holder.binding.userImage.setImageResource(R.drawable.ic_user_icon);
        }

    }

    public class CustomViewHolder extends RecyclerView.ViewHolder {

        ItemInvitePkBattleBinding binding;

        public CustomViewHolder(@NonNull ItemInvitePkBattleBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        public void bind(int position, AdapterClickListener listener, Object object) {
            binding.actionTxt.setOnClickListener(v -> listener.onItemClick(v, position, object));
        }
    }


}